<?php 
/*******************************************************************************************
						Coder Name	:	Jimit Bagadiya
						Date		:	2-May-2005
						Aim		:	common validation
		
********************************************************************************************/



/********************************** NUMERIC CHECK ********************************/
/* required to pass object and the id of next cell where you want to print error 
		it will check for only 0-9
*/ 


function check_Numeric($myfld, $field_name)
{
	if(ereg('[^0-9]', $myfld) )
		return "Please, enter valid ".$field_name . "<br>";

	return;
}

//Check Price - used to check Amount like 123.66
function isPrice($myfld, $field_name)
{
	if(!is_numeric($myfld) )
		return $field_name . " is not numeric<br>";

	return;
}


/********************************** CHECK FOR BLANK ********************************/
/* pass the object and id of the next cell	*/ 


function check_Blank($myfld,$field_name)
{
	if(strlen(trim($myfld))==0)
		//return $field_name . " is not entered<br>";
		return "Please, Enter " . $field_name . "<br />" ;

	return;
}

/******************************** FUNCTION TO CHECK DATE ******************************/
/* required to pass date and format of that date

	year is between 1 and 32767 inclusive 
	month is between 1 and 12 inclusive 
	Day is within the allowed number of days for the given month. 
		Leap years are taken into consideration.
		
*/

function check_Date($year, $month, $day,$field_name) 
{
	if (checkdate($year, $month, $day)) 
		return "";
	else
		return $field_name . ": Please, Enter Valid Date<br>";
}

function check_document($filename, $field_name)
{	
	$extArray = array(".doc", ".txt", ".pdf", ".rtf");
	
	if (!in_array(strrchr($filename,"."),$extArray)) 
		return $field_name . " : wrong document format<br>";	
	else
		return "";
}

function check_audiovideo($filename, $field_name)
{	
	$extArray = array(".fla",".spa",".ssk",".swf");
	
	if (!in_array(strrchr($filename,"."),$extArray)) 
		return $field_name . " : wrong audio/video format<br>";	
	else
		return "";
}

/******************************** FUNCTION TO CHECK VIDEO EXTATION	 ******************************/
/* pass the file name
*/


function check_Video($filename, $field_name)
{	
	$extArray = array();
	
	if (!in_array(strrchr($filename,"."),$extArray)) 
		return $field_name . " : wrong video format<br>";	
	else
		return "";
}



/******************************** FUNCTION TO CHECK IMAGE EXTATION ******************************/
/* pass the file name
*/

function check_Image($filename, $field_name)
{
	
	$extArray = array(".gif", ".jpg", ".jpeg");
	
	if (!in_array(strtolower(strrchr($filename,".")),$extArray))  {
		return $field_name . " : wrong image format<br>";	
	} else {
		return "";
	}
}


/******************************** FUNCTION TO CHECK AUDIO EXTATION	 ******************************/
/* required to pass object and the id of next cell where you want to print error 
*/

function check_Audio($filename, $field_name)
{
	
	$extArray = array(".mp3", ".wav", ".wma", ".au", ".sam", ".smp", ".mp2", ".ram", ".rm");
	
	if (!in_array(strrchr($filename,"."),$extArray)) 
		return $field_name . " : wrong audio format<br>";	
	else
		return "";
}


/********************************** CHECK FOR EMAIL ********************************/
/* pass the email address	*/

function check_Email($sEmailAddress,$field_name)
{

	if (ord(check_Length($sEmailAddress,"7","40"))==0)
	{	
		 if (!eregi("^[-_a-z0-9]+(\.[-_a-z0-9-]+)*@[-a-z0-9]+(\.[-a-z0-9]+)*(\.[a-z]{2,3})$",$sEmailAddress))
		{
			return "Please, Enter Valid " .$field_name."<br>";
		}		
		return "";
	} else {
		return "Please, Enter Valid Email<br>";		
	}
}

/********************************** CHECK FOR ALPHANUMERIC ********************************/
/* pass the object and id of the next cell	

	it will check for only 0-9,A-Z,a-z
*/ 

function check_AlphaNumeric($myfld, $field_name)
{	
	if(ereg('[^A-Za-z0-9]', $myfld))  		
		return $field_name . " required only alphanumeric character<br>";	
	else
		return "";
}

/********************************** CHECK FOR Password ********************************/
/* pass the object and id of the next cell	

	it will check for only 0-9,A-Z,a-z
*/ 

function check_passwd($myfld, $field_name)
{	
	if(ereg('[^A-Za-z0-9]', $myfld))  		
		return "Password should not contain special characters !<br>";	
	else
		return "";
}

/********************************** CHECK FOR ALPHABETIC ********************************/
/* pass the object and id of the next cell	
	it will check for only a-z, A-Z

*/ 


function check_Alpha($myfld, $field_name)
{	
	if(ereg('[^A-Za-z]', $myfld))  
		return $field_name . " required only alphabatic character<br>";	
	else
		return "";
}

/********************************** CHECK FOR MIMINUM & MAXIMUM LENGHT ********************************/
/* required to pass object and the id of next cell where you want to print error 	
	minValue	:	number of minimum character
	maxValue	:	number of maximum character
*/ 

function check_Length($myfld, $minValue, $maxValue, $field_name="")
{	
	  if ( strlen($myfld) >= $minValue && strlen($myfld)<=$maxValue )
		 return "";
	  else 
	  	return $field_name . " must be minimum of " . $minValue ." and maximum of " . $maxValue ." character<br>";
}


/********************************** COMBO CHECK ********************************/

function check_Combo($myfld, $field_name, $value)
{	
	  if ($myfld!=$value)
		 return "";
	  else 
	  	return "Please, Select " .$field_name."<br>";
}


/********************************** STRING COMPARISION ********************************/
/*  required to pass object and the id of next cell where you want to print error 	  */ 

function string_compare($myfld, $myfld2, $field_name, $field_name2)
{

	  if (strcmp($myfld,$myfld2)==0)
		 return "";
	  else 
	  	return $field_name . " and " . $field_name2 . " are not same<br>";
}


/********************************** CHECK FOR SPECIAL CHARACHTER ********************************/
/* pass the object and id of the next cell	

*/ 


function check_Specialchar($myfld, $field_name)
{	
	for ($i=0; $i < strlen($myfld); $i++) 
	{
		if (!ereg("[a-zA-Z0-9]", $myfld{$i})) {
			return $field_name . " contain spacial character<br>";
		}
	}
	return "";	
}

/********************************** CHECK FOR ALLOWED SPECIAL CHARACHTER ********************************/
/* pass the object and id of the next cell	

*/ 


function check_withSpecialchar($myfld, $field_name, $specialchar)
{	
	$special_char	=	"@#$%&*!()+=[]\\\';,-_./{}|\":<>?^";	
	
	for ($i=0; $i < strlen($specialchar); $i++) 
	{
		$special_char=str_replace($specialchar[$i],"",$special_char);
	}
	
	
	for ($i=0; $i < strlen($special_char); $i++) 
	{
		if ( strstr($myfld,$special_char[$i])!= false ) {
			return "Spacial character are not allowed<br>";
		}
	}
	return "";	

}
?>

